#ifndef _HL_UNJUNK_H_
#define _HL_UNJUNK_H_

#pragma once
#include <list>

extern "C" {
	#include "libdis.h"
}

class unjunk
{
public:
	unjunk(void);
	~unjunk(void);
	void init(long map_old,long map_new,long _img_base);

	void replace_func(long func_addr,long func_new);

	long x86dis_resolver( x86_op_t *op, x86_insn_t *insn );
	void x86dis_manual_print( x86_insn_t *insn, void *arg );
	int rva_list_add( unsigned long rva );
	
private:
	std::list<long> _rva_list; 
	long _offset_start;
	long _offset_new;
	long _map_old;
	long _map_new;
	long _current;
	long _start;
	long _img_base;
	bool force_quit;
	int op_number;
};

#endif  /* _HL_UNJUNK_H_ */ 
