#include <stdlib.h>
#include <stdio.h>
#include "ia32_list.h"
struct DISASMLIST disasm_list_head = {0};

int disasm_list_add( unsigned long rva ) {
	struct DISASMLIST *rl, *rl_new;

	for ( rl = &disasm_list_head; rl; rl = rl->next ) {
		/* first rva is always 0 -- the list head */
		if ( rva > rl->rva ) {
			if ( ! rl->next || rva < rl->next->rva ) {
				//printf("\n\nAdding rva = %X\n\n",rva);
				/* we use exit() to free this, btw */
				rl_new = (struct DISASMLIST *)calloc(sizeof(struct DISASMLIST), 1);
				rl_new->rva = rva;
				rl_new->next = rl->next;
				rl->next = rl_new;
				return(1);
			}
		} else if ( rva == rl->rva ) {
			return(0);	/* already seen this rva */
		}
	}
	return(0);
}

int disasm_list_pop(void)
{
    struct DISASMLIST *rl, *rl_new;
	int result;
	
	rl = &disasm_list_head;
	if(rl->next == 0)
		return 0;
	else
	{
		rl = rl->next;
		result = rl->rva;
		rl_new=rl;
		rl=rl->next;
		disasm_list_head.next=rl;
		free(rl_new);
		return result;
	}
}