#ifndef _HL_DISASM_H_
#define _HL_DISASM_H_

#pragma once
extern "C"
{
	#include "libdis.h"
	#include "ia32_list.h"
}

class disasm
{
public:
	disasm(void);
	~disasm(void);
	int do_disasm( unsigned int offset);
	void init(unsigned char *lbuf, unsigned int lbuf_len,unsigned long lbuf_rva);
protected:
	int follow_insn_dest( x86_insn_t *insn );
	int insn_doesnt_return( x86_insn_t *insn );
	long resolver( x86_op_t *op, x86_insn_t *insn );
	long resolve( x86_op_t *op, x86_insn_t *insn );
	void do_instruction(x86_insn_t *insn);
	int disasm_func(unsigned int offset);
	
private:
	bool force_quit;
	unsigned char *buf;
	unsigned int buf_len;
    unsigned long buf_rva;
};

#endif  /* _HL_DISASM_H_ */ 
