#include <idc.idc>


#define START_ADDRESS 0x401023
#define END_ADDRESS 0x404C5D


static instruction_count(){
	auto from;
	auto count;

	count = 0;
	from = START_ADDRESS;
	while(from<END_ADDRESS){
		from = from + ItemSize(from);
		count++;
	}

	return count;
}

static NOPage(ea){
	auto len_inst;
	auto count;

	count = 0;
	len_inst = ItemSize(ea);
	while(count<len_inst){
		PatchByte(ea+count,0x90);
		count = count + 1;
	}
}

static opposite_inst(i1,i2){
	if( (strstr(i1,"rol")!=-1) && (strstr(i2,"ror")!=-1))
		return 1;
	else if( (strstr(i1,"ror")!=-1) && (strstr(i2,"rol")!=-1))
		return 1;
	else if( (strstr(i1,"xor")!=-1) && (strstr(i2,"xor")!=-1))
		return 1;
	else if( (strstr(i1,"shr")!=-1) && (strstr(i2,"shl")!=-1))
		return 1;
	else if( (strstr(i1,"shl")!=-1) && (strstr(i2,"shr")!=-1))
		return 1;
	else if( (strstr(i1,"add")!=-1) && (strstr(i2,"sub")!=-1))
		return 1;
	else if( (strstr(i1,"sub")!=-1) && (strstr(i2,"add")!=-1))
		return 1;
	return 0;
}

static opposite(l1,l2){
	auto op1,op2,r1,r2;

	op1 = substr(l1,0,3);
	op2 = substr(l2,0,3);
	r1 = substr(l1,3,-1);
	r2 = substr(l2,3,-1);

	if(strstr(r1,r2)==-1)
		return 0;
	return opposite_inst(op1,op2);
}


static HideJunkType1(){
	auto from,from2,code1,code2;
	auto count,len;

	count = 0;
	len = 0;
	from = START_ADDRESS;

	while(from<END_ADDRESS){
		code1 = GetDisasm(from);
		from2 = from + ItemSize(from);
		
		while(count<128){
			code2 = GetDisasm(from2); 
			if(opposite(code1,code2)){
				//HideArea(from,from+ItemSize(from),"junky2 :)",0,0,4);
				//HideArea(from2,from2+ItemSize(from2),"junky2 :)",0,0,4);
				NOPage(from);
				NOPage(from2);
				len = len + 2;
				break;
			}				
			count = count + 1;	
			from2 = from2 + ItemSize(from2);
		}
				
		count = 0;
		from = from + ItemSize(from);
	}

	return len;
}




static not_used(ops){
	auto first;
	
	if(strstr(ops,",")==-1)
		return 0;
	first = substr(ops,0,strstr(ops,","));

	if(strstr(first,"ebp")!=-1)
		return 1;
	else if(strstr(first,"esp")!=-1)
		return 1;
	else if(strstr(first,"ecx")!=-1)
		return 1;
	else if(strstr(first,"edx")!=-1)
		return 1;
	else if(strstr(first,"esi")!=-1)
		return 1;
	else if(strstr(first,"edi")!=-1)
		return 1;
	else if(strstr(first,"di")!=-1)
		return 1;
	else if(strstr(first,"si")!=-1)
		return 1;
	else if(strstr(first,"dx")!=-1)
		return 1;
	else if(strstr(first,"cx")!=-1)
		return 1;
	else if(strstr(first,"dh")!=-1)
		return 1;
	else if(strstr(first,"ch")!=-1)
		return 1;
	else if(strstr(first,"dl")!=-1)
		return 1;
	else if(strstr(first,"cl")!=-1)
		return 1;
	else if(strstr(first,"bp")!=-1)
		return 1;
	else if(strstr(first,"sp")!=-1)
		return 1;
	return 0;
}

static HideJunkType2(){
	auto from,count,operands;

	count = 0;
	from = START_ADDRESS;

	while(from < 0x4028DE){
		operands = substr(GetDisasm(from),3,-1);
		if(not_used(operands)){
			NOPage(from);
			count = count + 1;
		}
		from = from + ItemSize(from);
	}

	return count;
}


static not_used2(ops){
	auto first;
	
	if(strstr(ops,",")==-1)
		return 0;
	first = substr(ops,0,strstr(ops,","));

	if(strstr(first,"ebp")!=-1)
		return 1;
	else if(strstr(first,"esp")!=-1)
		return 1;
	else if(strstr(first,"edx")!=-1)
		return 1;
	else if(strstr(first,"esi")!=-1)
		return 1;
	else if(strstr(first,"edi")!=-1)
		return 1;
	else if(strstr(first,"di")!=-1)
		return 1;
	else if(strstr(first,"si")!=-1)
		return 1;
	else if(strstr(first,"dx")!=-1)
		return 1;
	else if(strstr(first,"dh")!=-1)
		return 1;
	else if(strstr(first,"dl")!=-1)
		return 1;
	else if(strstr(first,"bp")!=-1)
		return 1;
	else if(strstr(first,"sp")!=-1)
		return 1;

	return 0;
}

static HideJunkType3(){
	auto from,count,operands;

	count = 0;
	from = 0x4028EE;

	while(from < END_ADDRESS){
		operands = substr(GetDisasm(from),3,-1);
		if(not_used2(operands)){
			NOPage(from);
			count = count + 1;
		}
		from = from + ItemSize(from);
	}

	return count;
}


static main(){

	auto count;

	Message("Nb instructions : %u\n",instruction_count());

	count = HideJunkType1();
	Message("Removing %u instructions (JUNK type I)\n",count);

	count = HideJunkType2();
	Message("Removing %u instructions (JUNK type II)\n",count);

	count = HideJunkType3();
	Message("Removing %u instructions (JUNK type III)\n",count);

}
